package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class TransitGatewayAttachment(
    transitGatewayAttachmentId: Optional[String] = Optional.Absent,
    transitGatewayId: Optional[String] = Optional.Absent,
    transitGatewayOwnerId: Optional[String] = Optional.Absent,
    resourceOwnerId: Optional[String] = Optional.Absent,
    resourceType: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayAttachmentState] =
      Optional.Absent,
    association: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentAssociation
    ] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment = {
    import TransitGatewayAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(
        transitGatewayOwnerId.map(value => value: java.lang.String)
      )(_.transitGatewayOwnerId)
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly =
    zio.aws.ec2.model.TransitGatewayAttachment.wrap(buildAwsValue())
}
object TransitGatewayAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayAttachment =
      zio.aws.ec2.model.TransitGatewayAttachment(
        transitGatewayAttachmentId.map(value => value),
        transitGatewayId.map(value => value),
        transitGatewayOwnerId.map(value => value),
        resourceOwnerId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        state.map(value => value),
        association.map(value => value.asEditable),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Optional[String]
    def transitGatewayId: Optional[String]
    def transitGatewayOwnerId: Optional[String]
    def resourceOwnerId: Optional[String]
    def resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def resourceId: Optional[String]
    def state: Optional[zio.aws.ec2.model.TransitGatewayAttachmentState]
    def association: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly
    ]
    def creationTime: Optional[DateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getTransitGatewayOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayOwnerId", transitGatewayOwnerId)
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment
  ) extends zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly {
    override val transitGatewayAttachmentId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayAttachmentId())
        .map(value => value: String)
    override val transitGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayId())
      .map(value => value: String)
    override val transitGatewayOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayOwnerId())
      .map(value => value: String)
    override val resourceOwnerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwnerId())
      .map(value => value: String)
    override val resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
        )
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentState.wrap(value)
        )
    override val association: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.association())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentAssociation.wrap(value)
      )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachment
  ): zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly = new Wrapper(impl)
}
