package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrafficMirrorFilterRule(
    trafficMirrorFilterRuleId: Optional[String] = Optional.Absent,
    trafficMirrorFilterId: Optional[String] = Optional.Absent,
    trafficDirection: Optional[zio.aws.ec2.model.TrafficDirection] =
      Optional.Absent,
    ruleNumber: Optional[Integer] = Optional.Absent,
    ruleAction: Optional[zio.aws.ec2.model.TrafficMirrorRuleAction] =
      Optional.Absent,
    protocol: Optional[Integer] = Optional.Absent,
    destinationPortRange: Optional[zio.aws.ec2.model.TrafficMirrorPortRange] =
      Optional.Absent,
    sourcePortRange: Optional[zio.aws.ec2.model.TrafficMirrorPortRange] =
      Optional.Absent,
    destinationCidrBlock: Optional[String] = Optional.Absent,
    sourceCidrBlock: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule = {
    import TrafficMirrorFilterRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule
      .builder()
      .optionallyWith(
        trafficMirrorFilterRuleId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterRuleId)
      .optionallyWith(
        trafficMirrorFilterId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterId)
      .optionallyWith(trafficDirection.map(value => value.unwrap))(
        _.trafficDirection
      )
      .optionallyWith(ruleNumber.map(value => value: java.lang.Integer))(
        _.ruleNumber
      )
      .optionallyWith(ruleAction.map(value => value.unwrap))(_.ruleAction)
      .optionallyWith(protocol.map(value => value: java.lang.Integer))(
        _.protocol
      )
      .optionallyWith(destinationPortRange.map(value => value.buildAwsValue()))(
        _.destinationPortRange
      )
      .optionallyWith(sourcePortRange.map(value => value.buildAwsValue()))(
        _.sourcePortRange
      )
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(sourceCidrBlock.map(value => value: java.lang.String))(
        _.sourceCidrBlock
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorFilterRule.wrap(buildAwsValue())
}
object TrafficMirrorFilterRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorFilterRule =
      zio.aws.ec2.model.TrafficMirrorFilterRule(
        trafficMirrorFilterRuleId.map(value => value),
        trafficMirrorFilterId.map(value => value),
        trafficDirection.map(value => value),
        ruleNumber.map(value => value),
        ruleAction.map(value => value),
        protocol.map(value => value),
        destinationPortRange.map(value => value.asEditable),
        sourcePortRange.map(value => value.asEditable),
        destinationCidrBlock.map(value => value),
        sourceCidrBlock.map(value => value),
        description.map(value => value)
      )
    def trafficMirrorFilterRuleId: Optional[String]
    def trafficMirrorFilterId: Optional[String]
    def trafficDirection: Optional[zio.aws.ec2.model.TrafficDirection]
    def ruleNumber: Optional[Integer]
    def ruleAction: Optional[zio.aws.ec2.model.TrafficMirrorRuleAction]
    def protocol: Optional[Integer]
    def destinationPortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly]
    def sourcePortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly]
    def destinationCidrBlock: Optional[String]
    def sourceCidrBlock: Optional[String]
    def description: Optional[String]
    def getTrafficMirrorFilterRuleId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("trafficMirrorFilterRuleId", trafficMirrorFilterRuleId)
    def getTrafficMirrorFilterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorFilterId", trafficMirrorFilterId)
    def getTrafficDirection
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficDirection] =
      AwsError.unwrapOptionField("trafficDirection", trafficDirection)
    def getRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ruleNumber", ruleNumber)
    def getRuleAction
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorRuleAction] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getProtocol: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestinationPortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly
    ] = AwsError.unwrapOptionField("destinationPortRange", destinationPortRange)
    def getSourcePortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly
    ] = AwsError.unwrapOptionField("sourcePortRange", sourcePortRange)
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getSourceCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceCidrBlock", sourceCidrBlock)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule
  ) extends zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly {
    override val trafficMirrorFilterRuleId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorFilterRuleId())
        .map(value => value: String)
    override val trafficMirrorFilterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficMirrorFilterId())
      .map(value => value: String)
    override val trafficDirection
        : Optional[zio.aws.ec2.model.TrafficDirection] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficDirection())
      .map(value => zio.aws.ec2.model.TrafficDirection.wrap(value))
    override val ruleNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleNumber())
      .map(value => value: Integer)
    override val ruleAction
        : Optional[zio.aws.ec2.model.TrafficMirrorRuleAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleAction())
        .map(value => zio.aws.ec2.model.TrafficMirrorRuleAction.wrap(value))
    override val protocol: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: Integer)
    override val destinationPortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPortRange())
        .map(value => zio.aws.ec2.model.TrafficMirrorPortRange.wrap(value))
    override val sourcePortRange
        : Optional[zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePortRange())
        .map(value => zio.aws.ec2.model.TrafficMirrorPortRange.wrap(value))
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val sourceCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCidrBlock())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule
  ): zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly = new Wrapper(impl)
}
