package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait Tenancy {
  def unwrap: software.amazon.awssdk.services.ec2.model.Tenancy
}
object Tenancy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.Tenancy
  ): zio.aws.ec2.model.Tenancy = value match {
    case software.amazon.awssdk.services.ec2.model.Tenancy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.Tenancy.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.ec2.model.Tenancy.DEDICATED =>
      val r = dedicated
      r
    case software.amazon.awssdk.services.ec2.model.Tenancy.HOST =>
      val r = host
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.Tenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Tenancy =
      software.amazon.awssdk.services.ec2.model.Tenancy.UNKNOWN_TO_SDK_VERSION
  }
  case object default extends zio.aws.ec2.model.Tenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Tenancy =
      software.amazon.awssdk.services.ec2.model.Tenancy.DEFAULT
  }
  case object dedicated extends zio.aws.ec2.model.Tenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Tenancy =
      software.amazon.awssdk.services.ec2.model.Tenancy.DEDICATED
  }
  case object host extends zio.aws.ec2.model.Tenancy {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Tenancy =
      software.amazon.awssdk.services.ec2.model.Tenancy.HOST
  }
}
