package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SecurityGroupRuleId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityGroupRuleUpdate(
    securityGroupRuleId: SecurityGroupRuleId,
    securityGroupRule: Optional[zio.aws.ec2.model.SecurityGroupRuleRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate = {
    import SecurityGroupRuleUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
      .builder()
      .securityGroupRuleId(
        SecurityGroupRuleId.unwrap(securityGroupRuleId): java.lang.String
      )
      .optionallyWith(securityGroupRule.map(value => value.buildAwsValue()))(
        _.securityGroupRule
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly =
    zio.aws.ec2.model.SecurityGroupRuleUpdate.wrap(buildAwsValue())
}
object SecurityGroupRuleUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupRuleUpdate =
      zio.aws.ec2.model.SecurityGroupRuleUpdate(
        securityGroupRuleId,
        securityGroupRule.map(value => value.asEditable)
      )
    def securityGroupRuleId: SecurityGroupRuleId
    def securityGroupRule
        : Optional[zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly]
    def getSecurityGroupRuleId: ZIO[Any, Nothing, SecurityGroupRuleId] =
      ZIO.succeed(securityGroupRuleId)
    def getSecurityGroupRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroupRule", securityGroupRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ) extends zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly {
    override val securityGroupRuleId: SecurityGroupRuleId =
      zio.aws.ec2.model.primitives
        .SecurityGroupRuleId(impl.securityGroupRuleId())
    override val securityGroupRule
        : Optional[zio.aws.ec2.model.SecurityGroupRuleRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupRule())
        .map(value => zio.aws.ec2.model.SecurityGroupRuleRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleUpdate
  ): zio.aws.ec2.model.SecurityGroupRuleUpdate.ReadOnly = new Wrapper(impl)
}
