package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesMonitoring(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring = {
    import ScheduledInstancesMonitoring.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesMonitoring.wrap(buildAwsValue())
}
object ScheduledInstancesMonitoring {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesMonitoring =
      zio.aws.ec2.model
        .ScheduledInstancesMonitoring(enabled.map(value => value))
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring
  ) extends zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring
  ): zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly = new Wrapper(impl)
}
