package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceIamInstanceProfileAssociationResponse(
    iamInstanceProfileAssociation: Optional[
      zio.aws.ec2.model.IamInstanceProfileAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse = {
    import ReplaceIamInstanceProfileAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse
      .builder()
      .optionallyWith(
        iamInstanceProfileAssociation.map(value => value.buildAwsValue())
      )(_.iamInstanceProfileAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.ReadOnly =
    zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse
      .wrap(buildAwsValue())
}
object ReplaceIamInstanceProfileAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse =
      zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse(
        iamInstanceProfileAssociation.map(value => value.asEditable)
      )
    def iamInstanceProfileAssociation
        : Optional[zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly]
    def getIamInstanceProfileAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "iamInstanceProfileAssociation",
      iamInstanceProfileAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse
  ) extends zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.ReadOnly {
    override val iamInstanceProfileAssociation
        : Optional[zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfileAssociation())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileAssociation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceIamInstanceProfileAssociationResponse
  ): zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
