package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NatGatewayState {
  def unwrap: software.amazon.awssdk.services.ec2.model.NatGatewayState
}
object NatGatewayState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NatGatewayState
  ): zio.aws.ec2.model.NatGatewayState = value match {
    case software.amazon.awssdk.services.ec2.model.NatGatewayState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayState.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.NatGatewayState.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.NatGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayState =
      software.amazon.awssdk.services.ec2.model.NatGatewayState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.NatGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayState =
      software.amazon.awssdk.services.ec2.model.NatGatewayState.PENDING
  }
  case object failed extends zio.aws.ec2.model.NatGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayState =
      software.amazon.awssdk.services.ec2.model.NatGatewayState.FAILED
  }
  case object available extends zio.aws.ec2.model.NatGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayState =
      software.amazon.awssdk.services.ec2.model.NatGatewayState.AVAILABLE
  }
  case object deleting extends zio.aws.ec2.model.NatGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayState =
      software.amazon.awssdk.services.ec2.model.NatGatewayState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.NatGatewayState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NatGatewayState =
      software.amazon.awssdk.services.ec2.model.NatGatewayState.DELETED
  }
}
