package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ConnectionNotificationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointConnectionNotificationRequest(
    connectionNotificationId: ConnectionNotificationId,
    connectionNotificationArn: Optional[String] = Optional.Absent,
    connectionEvents: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest = {
    import ModifyVpcEndpointConnectionNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest
      .builder()
      .connectionNotificationId(
        ConnectionNotificationId.unwrap(
          connectionNotificationId
        ): java.lang.String
      )
      .optionallyWith(
        connectionNotificationArn.map(value => value: java.lang.String)
      )(_.connectionNotificationArn)
      .optionallyWith(
        connectionEvents.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.connectionEvents)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest
      .wrap(buildAwsValue())
}
object ModifyVpcEndpointConnectionNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest =
      zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest(
        connectionNotificationId,
        connectionNotificationArn.map(value => value),
        connectionEvents.map(value => value)
      )
    def connectionNotificationId: ConnectionNotificationId
    def connectionNotificationArn: Optional[String]
    def connectionEvents: Optional[List[String]]
    def getConnectionNotificationId
        : ZIO[Any, Nothing, ConnectionNotificationId] =
      ZIO.succeed(connectionNotificationId)
    def getConnectionNotificationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("connectionNotificationArn", connectionNotificationArn)
    def getConnectionEvents: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("connectionEvents", connectionEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest
  ) extends zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest.ReadOnly {
    override val connectionNotificationId: ConnectionNotificationId =
      zio.aws.ec2.model.primitives
        .ConnectionNotificationId(impl.connectionNotificationId())
    override val connectionNotificationArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionNotificationArn())
        .map(value => value: String)
    override val connectionEvents: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionEvents())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointConnectionNotificationRequest
  ): zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
