package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessTrustProviderOidcOptions(
    scope: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions = {
    import ModifyVerifiedAccessTrustProviderOidcOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions
      .builder()
      .optionallyWith(scope.map(value => value: java.lang.String))(_.scope)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessTrustProviderOidcOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions =
      zio.aws.ec2.model
        .ModifyVerifiedAccessTrustProviderOidcOptions(scope.map(value => value))
    def scope: Optional[String]
    def getScope: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions.ReadOnly {
    override val scope: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scope())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions
  ): zio.aws.ec2.model.ModifyVerifiedAccessTrustProviderOidcOptions.ReadOnly =
    new Wrapper(impl)
}
