package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessGroupPolicyRequest(
    verifiedAccessGroupId: VerifiedAccessGroupId,
    policyEnabled: Boolean,
    policyDocument: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest = {
    import ModifyVerifiedAccessGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
      .builder()
      .verifiedAccessGroupId(
        VerifiedAccessGroupId.unwrap(verifiedAccessGroupId): java.lang.String
      )
      .policyEnabled(policyEnabled: java.lang.Boolean)
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest(
        verifiedAccessGroupId,
        policyEnabled,
        policyDocument.map(value => value),
        clientToken.map(value => value)
      )
    def verifiedAccessGroupId: VerifiedAccessGroupId
    def policyEnabled: Boolean
    def policyDocument: Optional[String]
    def clientToken: Optional[String]
    def getVerifiedAccessGroupId: ZIO[Any, Nothing, VerifiedAccessGroupId] =
      ZIO.succeed(verifiedAccessGroupId)
    def getPolicyEnabled: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(policyEnabled)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest.ReadOnly {
    override val verifiedAccessGroupId: VerifiedAccessGroupId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessGroupId(impl.verifiedAccessGroupId())
    override val policyEnabled: Boolean = impl.policyEnabled(): Boolean
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
