package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamResourceDiscoveryId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpamResourceDiscovery(
    ownerId: Optional[String] = Optional.Absent,
    ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId] =
      Optional.Absent,
    ipamResourceDiscoveryArn: Optional[String] = Optional.Absent,
    ipamResourceDiscoveryRegion: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    operatingRegions: Optional[
      Iterable[zio.aws.ec2.model.IpamOperatingRegion]
    ] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.IpamResourceDiscoveryState] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery = {
    import IpamResourceDiscovery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        ipamResourceDiscoveryId.map(value =>
          IpamResourceDiscoveryId.unwrap(value): java.lang.String
        )
      )(_.ipamResourceDiscoveryId)
      .optionallyWith(
        ipamResourceDiscoveryArn.map(value => value: java.lang.String)
      )(_.ipamResourceDiscoveryArn)
      .optionallyWith(
        ipamResourceDiscoveryRegion.map(value => value: java.lang.String)
      )(_.ipamResourceDiscoveryRegion)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        operatingRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operatingRegions)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly =
    zio.aws.ec2.model.IpamResourceDiscovery.wrap(buildAwsValue())
}
object IpamResourceDiscovery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamResourceDiscovery =
      zio.aws.ec2.model.IpamResourceDiscovery(
        ownerId.map(value => value),
        ipamResourceDiscoveryId.map(value => value),
        ipamResourceDiscoveryArn.map(value => value),
        ipamResourceDiscoveryRegion.map(value => value),
        description.map(value => value),
        operatingRegions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isDefault.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ownerId: Optional[String]
    def ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId]
    def ipamResourceDiscoveryArn: Optional[String]
    def ipamResourceDiscoveryRegion: Optional[String]
    def description: Optional[String]
    def operatingRegions
        : Optional[List[zio.aws.ec2.model.IpamOperatingRegion.ReadOnly]]
    def isDefault: Optional[Boolean]
    def state: Optional[zio.aws.ec2.model.IpamResourceDiscoveryState]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getIpamResourceDiscoveryId
        : ZIO[Any, AwsError, IpamResourceDiscoveryId] = AwsError
      .unwrapOptionField("ipamResourceDiscoveryId", ipamResourceDiscoveryId)
    def getIpamResourceDiscoveryArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("ipamResourceDiscoveryArn", ipamResourceDiscoveryArn)
    def getIpamResourceDiscoveryRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ipamResourceDiscoveryRegion",
        ipamResourceDiscoveryRegion
      )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOperatingRegions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamOperatingRegion.ReadOnly
    ]] = AwsError.unwrapOptionField("operatingRegions", operatingRegions)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamResourceDiscoveryState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery
  ) extends zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly {
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val ipamResourceDiscoveryId: Optional[IpamResourceDiscoveryId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscoveryId())
        .map(value =>
          zio.aws.ec2.model.primitives.IpamResourceDiscoveryId(value)
        )
    override val ipamResourceDiscoveryArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscoveryArn())
        .map(value => value: String)
    override val ipamResourceDiscoveryRegion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscoveryRegion())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val operatingRegions
        : Optional[List[zio.aws.ec2.model.IpamOperatingRegion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamOperatingRegion.wrap(item)
          }.toList
        )
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val state: Optional[zio.aws.ec2.model.IpamResourceDiscoveryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.IpamResourceDiscoveryState.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamResourceDiscovery
  ): zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly = new Wrapper(impl)
}
