package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceNetworkInterface(
    association: Optional[
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation
    ] = Optional.Absent,
    attachment: Optional[zio.aws.ec2.model.InstanceNetworkInterfaceAttachment] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    groups: Optional[Iterable[zio.aws.ec2.model.GroupIdentifier]] =
      Optional.Absent,
    ipv6Addresses: Optional[Iterable[zio.aws.ec2.model.InstanceIpv6Address]] =
      Optional.Absent,
    macAddress: Optional[String] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent,
    privateIpAddresses: Optional[
      Iterable[zio.aws.ec2.model.InstancePrivateIpAddress]
    ] = Optional.Absent,
    sourceDestCheck: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.NetworkInterfaceStatus] =
      Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    interfaceType: Optional[String] = Optional.Absent,
    ipv4Prefixes: Optional[Iterable[zio.aws.ec2.model.InstanceIpv4Prefix]] =
      Optional.Absent,
    ipv6Prefixes: Optional[Iterable[zio.aws.ec2.model.InstanceIpv6Prefix]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface = {
    import InstanceNetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface
      .builder()
      .optionallyWith(association.map(value => value.buildAwsValue()))(
        _.association
      )
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(macAddress.map(value => value: java.lang.String))(
        _.macAddress
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.Boolean))(
        _.sourceDestCheck
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(interfaceType.map(value => value: java.lang.String))(
        _.interfaceType
      )
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly =
    zio.aws.ec2.model.InstanceNetworkInterface.wrap(buildAwsValue())
}
object InstanceNetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceNetworkInterface =
      zio.aws.ec2.model.InstanceNetworkInterface(
        association.map(value => value.asEditable),
        attachment.map(value => value.asEditable),
        description.map(value => value),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        macAddress.map(value => value),
        networkInterfaceId.map(value => value),
        ownerId.map(value => value),
        privateDnsName.map(value => value),
        privateIpAddress.map(value => value),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceDestCheck.map(value => value),
        status.map(value => value),
        subnetId.map(value => value),
        vpcId.map(value => value),
        interfaceType.map(value => value),
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def association: Optional[
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly
    ]
    def attachment: Optional[
      zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly
    ]
    def description: Optional[String]
    def groups: Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def ipv6Addresses
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]]
    def macAddress: Optional[String]
    def networkInterfaceId: Optional[String]
    def ownerId: Optional[String]
    def privateDnsName: Optional[String]
    def privateIpAddress: Optional[String]
    def privateIpAddresses
        : Optional[List[zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly]]
    def sourceDestCheck: Optional[Boolean]
    def status: Optional[zio.aws.ec2.model.NetworkInterfaceStatus]
    def subnetId: Optional[String]
    def vpcId: Optional[String]
    def interfaceType: Optional[String]
    def ipv4Prefixes
        : Optional[List[zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly]]
    def ipv6Prefixes
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly]]
    def getAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("association", association)
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Address.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getMacAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getSourceDestCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInterfaceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface
  ) extends zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly {
    override val association: Optional[
      zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.association())
      .map(value =>
        zio.aws.ec2.model.InstanceNetworkInterfaceAssociation.wrap(value)
      )
    override val attachment: Optional[
      zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachment())
      .map(value =>
        zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.wrap(value)
      )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val groups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.GroupIdentifier.wrap(item)
          }.toList
        )
    override val ipv6Addresses
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceIpv6Address.wrap(item)
          }.toList
        )
    override val macAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.macAddress())
      .map(value => value: String)
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
    override val privateIpAddresses
        : Optional[List[zio.aws.ec2.model.InstancePrivateIpAddress.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstancePrivateIpAddress.wrap(item)
          }.toList
        )
    override val sourceDestCheck: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDestCheck())
      .map(value => value: Boolean)
    override val status: Optional[zio.aws.ec2.model.NetworkInterfaceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.NetworkInterfaceStatus.wrap(value))
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val interfaceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.interfaceType())
      .map(value => value: String)
    override val ipv4Prefixes
        : Optional[List[zio.aws.ec2.model.InstanceIpv4Prefix.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv4Prefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceIpv4Prefix.wrap(item)
          }.toList
        )
    override val ipv6Prefixes
        : Optional[List[zio.aws.ec2.model.InstanceIpv6Prefix.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6Prefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceIpv6Prefix.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterface
  ): zio.aws.ec2.model.InstanceNetworkInterface.ReadOnly = new Wrapper(impl)
}
