package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCoipPoolUsageResponse(
    coipPoolId: Optional[String] = Optional.Absent,
    coipAddressUsages: Optional[Iterable[zio.aws.ec2.model.CoipAddressUsage]] =
      Optional.Absent,
    localGatewayRouteTableId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse = {
    import GetCoipPoolUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse
      .builder()
      .optionallyWith(coipPoolId.map(value => value: java.lang.String))(
        _.coipPoolId
      )
      .optionallyWith(
        coipAddressUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coipAddressUsages)
      .optionallyWith(
        localGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.localGatewayRouteTableId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetCoipPoolUsageResponse.ReadOnly =
    zio.aws.ec2.model.GetCoipPoolUsageResponse.wrap(buildAwsValue())
}
object GetCoipPoolUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetCoipPoolUsageResponse =
      zio.aws.ec2.model.GetCoipPoolUsageResponse(
        coipPoolId.map(value => value),
        coipAddressUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        localGatewayRouteTableId.map(value => value)
      )
    def coipPoolId: Optional[String]
    def coipAddressUsages
        : Optional[List[zio.aws.ec2.model.CoipAddressUsage.ReadOnly]]
    def localGatewayRouteTableId: Optional[String]
    def getCoipPoolId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("coipPoolId", coipPoolId)
    def getCoipAddressUsages: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CoipAddressUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("coipAddressUsages", coipAddressUsages)
    def getLocalGatewayRouteTableId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("localGatewayRouteTableId", localGatewayRouteTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse
  ) extends zio.aws.ec2.model.GetCoipPoolUsageResponse.ReadOnly {
    override val coipPoolId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.coipPoolId())
      .map(value => value: String)
    override val coipAddressUsages
        : Optional[List[zio.aws.ec2.model.CoipAddressUsage.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coipAddressUsages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CoipAddressUsage.wrap(item)
          }.toList
        )
    override val localGatewayRouteTableId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGatewayRouteTableId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageResponse
  ): zio.aws.ec2.model.GetCoipPoolUsageResponse.ReadOnly = new Wrapper(impl)
}
