package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAwsNetworkPerformanceDataResponse(
    dataResponses: Optional[Iterable[zio.aws.ec2.model.DataResponse]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse = {
    import GetAwsNetworkPerformanceDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse
      .builder()
      .optionallyWith(
        dataResponses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataResponses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetAwsNetworkPerformanceDataResponse.ReadOnly =
    zio.aws.ec2.model.GetAwsNetworkPerformanceDataResponse.wrap(buildAwsValue())
}
object GetAwsNetworkPerformanceDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetAwsNetworkPerformanceDataResponse =
      zio.aws.ec2.model.GetAwsNetworkPerformanceDataResponse(
        dataResponses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataResponses: Optional[List[zio.aws.ec2.model.DataResponse.ReadOnly]]
    def nextToken: Optional[String]
    def getDataResponses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.DataResponse.ReadOnly]] =
      AwsError.unwrapOptionField("dataResponses", dataResponses)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse
  ) extends zio.aws.ec2.model.GetAwsNetworkPerformanceDataResponse.ReadOnly {
    override val dataResponses
        : Optional[List[zio.aws.ec2.model.DataResponse.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataResponses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DataResponse.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAwsNetworkPerformanceDataResponse
  ): zio.aws.ec2.model.GetAwsNetworkPerformanceDataResponse.ReadOnly =
    new Wrapper(impl)
}
