package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAggregateIdFormatResponse(
    useLongIdsAggregated: Optional[Boolean] = Optional.Absent,
    statuses: Optional[Iterable[zio.aws.ec2.model.IdFormat]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse = {
    import DescribeAggregateIdFormatResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse
      .builder()
      .optionallyWith(
        useLongIdsAggregated.map(value => value: java.lang.Boolean)
      )(_.useLongIdsAggregated)
      .optionallyWith(
        statuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAggregateIdFormatResponse.ReadOnly =
    zio.aws.ec2.model.DescribeAggregateIdFormatResponse.wrap(buildAwsValue())
}
object DescribeAggregateIdFormatResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAggregateIdFormatResponse =
      zio.aws.ec2.model.DescribeAggregateIdFormatResponse(
        useLongIdsAggregated.map(value => value),
        statuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def useLongIdsAggregated: Optional[Boolean]
    def statuses: Optional[List[zio.aws.ec2.model.IdFormat.ReadOnly]]
    def getUseLongIdsAggregated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useLongIdsAggregated", useLongIdsAggregated)
    def getStatuses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IdFormat.ReadOnly]] =
      AwsError.unwrapOptionField("statuses", statuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse
  ) extends zio.aws.ec2.model.DescribeAggregateIdFormatResponse.ReadOnly {
    override val useLongIdsAggregated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useLongIdsAggregated())
      .map(value => value: Boolean)
    override val statuses: Optional[List[zio.aws.ec2.model.IdFormat.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IdFormat.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAggregateIdFormatResponse
  ): zio.aws.ec2.model.DescribeAggregateIdFormatResponse.ReadOnly = new Wrapper(
    impl
  )
}
