package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpcEndpointServiceConfigurationsRequest(
    serviceIds: Iterable[VpcEndpointServiceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest = {
    import DeleteVpcEndpointServiceConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
      .builder()
      .serviceIds(serviceIds.map { item =>
        VpcEndpointServiceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
      .wrap(buildAwsValue())
}
object DeleteVpcEndpointServiceConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest =
      zio.aws.ec2.model
        .DeleteVpcEndpointServiceConfigurationsRequest(serviceIds)
    def serviceIds: List[VpcEndpointServiceId]
    def getServiceIds: ZIO[Any, Nothing, List[VpcEndpointServiceId]] =
      ZIO.succeed(serviceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
  ) extends zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest.ReadOnly {
    override val serviceIds: List[VpcEndpointServiceId] = impl
      .serviceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.VpcEndpointServiceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
  ): zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
