package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolCoipId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCoipPoolRequest(coipPoolId: Ipv4PoolCoipId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest = {
    import DeleteCoipPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest
      .builder()
      .coipPoolId(Ipv4PoolCoipId.unwrap(coipPoolId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCoipPoolRequest.ReadOnly =
    zio.aws.ec2.model.DeleteCoipPoolRequest.wrap(buildAwsValue())
}
object DeleteCoipPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCoipPoolRequest =
      zio.aws.ec2.model.DeleteCoipPoolRequest(coipPoolId)
    def coipPoolId: Ipv4PoolCoipId
    def getCoipPoolId: ZIO[Any, Nothing, Ipv4PoolCoipId] =
      ZIO.succeed(coipPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest
  ) extends zio.aws.ec2.model.DeleteCoipPoolRequest.ReadOnly {
    override val coipPoolId: Ipv4PoolCoipId =
      zio.aws.ec2.model.primitives.Ipv4PoolCoipId(impl.coipPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCoipPoolRequest
  ): zio.aws.ec2.model.DeleteCoipPoolRequest.ReadOnly = new Wrapper(impl)
}
