package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointServiceConfigurationResponse(
    serviceConfiguration: Optional[zio.aws.ec2.model.ServiceConfiguration] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse = {
    import CreateVpcEndpointServiceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse
      .builder()
      .optionallyWith(serviceConfiguration.map(value => value.buildAwsValue()))(
        _.serviceConfiguration
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateVpcEndpointServiceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse =
      zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse(
        serviceConfiguration.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def serviceConfiguration
        : Optional[zio.aws.ec2.model.ServiceConfiguration.ReadOnly]
    def clientToken: Optional[String]
    def getServiceConfiguration
        : ZIO[Any, AwsError, zio.aws.ec2.model.ServiceConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("serviceConfiguration", serviceConfiguration)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse
  ) extends zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly {
    override val serviceConfiguration
        : Optional[zio.aws.ec2.model.ServiceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceConfiguration())
        .map(value => zio.aws.ec2.model.ServiceConfiguration.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse
  ): zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
