package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{PrivateIpAddressCount, NatGatewayId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AssignPrivateNatGatewayAddressRequest(
    natGatewayId: NatGatewayId,
    privateIpAddresses: Optional[Iterable[String]] = Optional.Absent,
    privateIpAddressCount: Optional[PrivateIpAddressCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest = {
    import AssignPrivateNatGatewayAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest
      .builder()
      .natGatewayId(NatGatewayId.unwrap(natGatewayId): java.lang.String)
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        privateIpAddressCount.map(value =>
          PrivateIpAddressCount.unwrap(value): Integer
        )
      )(_.privateIpAddressCount)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssignPrivateNatGatewayAddressRequest.ReadOnly =
    zio.aws.ec2.model.AssignPrivateNatGatewayAddressRequest
      .wrap(buildAwsValue())
}
object AssignPrivateNatGatewayAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssignPrivateNatGatewayAddressRequest =
      zio.aws.ec2.model.AssignPrivateNatGatewayAddressRequest(
        natGatewayId,
        privateIpAddresses.map(value => value),
        privateIpAddressCount.map(value => value)
      )
    def natGatewayId: NatGatewayId
    def privateIpAddresses: Optional[List[String]]
    def privateIpAddressCount: Optional[PrivateIpAddressCount]
    def getNatGatewayId: ZIO[Any, Nothing, NatGatewayId] =
      ZIO.succeed(natGatewayId)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getPrivateIpAddressCount: ZIO[Any, AwsError, PrivateIpAddressCount] =
      AwsError.unwrapOptionField("privateIpAddressCount", privateIpAddressCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest
  ) extends zio.aws.ec2.model.AssignPrivateNatGatewayAddressRequest.ReadOnly {
    override val natGatewayId: NatGatewayId =
      zio.aws.ec2.model.primitives.NatGatewayId(impl.natGatewayId())
    override val privateIpAddresses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val privateIpAddressCount: Optional[PrivateIpAddressCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddressCount())
        .map(value => zio.aws.ec2.model.primitives.PrivateIpAddressCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssignPrivateNatGatewayAddressRequest
  ): zio.aws.ec2.model.AssignPrivateNatGatewayAddressRequest.ReadOnly =
    new Wrapper(impl)
}
