package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait WeekDay {
  def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay
}
object WeekDay {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.WeekDay
  ): zio.aws.ec2.model.WeekDay = value match {
    case software.amazon.awssdk.services.ec2.model.WeekDay.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.WeekDay.SUNDAY =>
      val r = sunday
      r
    case software.amazon.awssdk.services.ec2.model.WeekDay.MONDAY =>
      val r = monday
      r
    case software.amazon.awssdk.services.ec2.model.WeekDay.TUESDAY =>
      val r = tuesday
      r
    case software.amazon.awssdk.services.ec2.model.WeekDay.WEDNESDAY =>
      val r = wednesday
      r
    case software.amazon.awssdk.services.ec2.model.WeekDay.THURSDAY =>
      val r = thursday
      r
    case software.amazon.awssdk.services.ec2.model.WeekDay.FRIDAY =>
      val r = friday
      r
    case software.amazon.awssdk.services.ec2.model.WeekDay.SATURDAY =>
      val r = saturday
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.WeekDay {
    override def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay =
      software.amazon.awssdk.services.ec2.model.WeekDay.UNKNOWN_TO_SDK_VERSION
  }
  case object sunday extends zio.aws.ec2.model.WeekDay {
    override def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay =
      software.amazon.awssdk.services.ec2.model.WeekDay.SUNDAY
  }
  case object monday extends zio.aws.ec2.model.WeekDay {
    override def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay =
      software.amazon.awssdk.services.ec2.model.WeekDay.MONDAY
  }
  case object tuesday extends zio.aws.ec2.model.WeekDay {
    override def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay =
      software.amazon.awssdk.services.ec2.model.WeekDay.TUESDAY
  }
  case object wednesday extends zio.aws.ec2.model.WeekDay {
    override def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay =
      software.amazon.awssdk.services.ec2.model.WeekDay.WEDNESDAY
  }
  case object thursday extends zio.aws.ec2.model.WeekDay {
    override def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay =
      software.amazon.awssdk.services.ec2.model.WeekDay.THURSDAY
  }
  case object friday extends zio.aws.ec2.model.WeekDay {
    override def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay =
      software.amazon.awssdk.services.ec2.model.WeekDay.FRIDAY
  }
  case object saturday extends zio.aws.ec2.model.WeekDay {
    override def unwrap: software.amazon.awssdk.services.ec2.model.WeekDay =
      software.amazon.awssdk.services.ec2.model.WeekDay.SATURDAY
  }
}
