package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class VpcEndpoint(
    vpcEndpointId: Optional[String] = Optional.Absent,
    vpcEndpointType: Optional[zio.aws.ec2.model.VpcEndpointType] =
      Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    serviceName: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.State] = Optional.Absent,
    policyDocument: Optional[String] = Optional.Absent,
    routeTableIds: Optional[Iterable[String]] = Optional.Absent,
    subnetIds: Optional[Iterable[String]] = Optional.Absent,
    groups: Optional[Iterable[zio.aws.ec2.model.SecurityGroupIdentifier]] =
      Optional.Absent,
    ipAddressType: Optional[zio.aws.ec2.model.IpAddressType] = Optional.Absent,
    dnsOptions: Optional[zio.aws.ec2.model.DnsOptions] = Optional.Absent,
    privateDnsEnabled: Optional[Boolean] = Optional.Absent,
    requesterManaged: Optional[Boolean] = Optional.Absent,
    networkInterfaceIds: Optional[Iterable[String]] = Optional.Absent,
    dnsEntries: Optional[Iterable[zio.aws.ec2.model.DnsEntry]] =
      Optional.Absent,
    creationTimestamp: Optional[MillisecondDateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    lastError: Optional[zio.aws.ec2.model.LastError] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.VpcEndpoint = {
    import VpcEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcEndpoint
      .builder()
      .optionallyWith(vpcEndpointId.map(value => value: java.lang.String))(
        _.vpcEndpointId
      )
      .optionallyWith(vpcEndpointType.map(value => value.unwrap))(
        _.vpcEndpointType
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(
        routeTableIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.routeTableIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(dnsOptions.map(value => value.buildAwsValue()))(
        _.dnsOptions
      )
      .optionallyWith(privateDnsEnabled.map(value => value: java.lang.Boolean))(
        _.privateDnsEnabled
      )
      .optionallyWith(requesterManaged.map(value => value: java.lang.Boolean))(
        _.requesterManaged
      )
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(
        dnsEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dnsEntries)
      .optionallyWith(
        creationTimestamp.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.creationTimestamp)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(lastError.map(value => value.buildAwsValue()))(
        _.lastError
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcEndpoint.ReadOnly =
    zio.aws.ec2.model.VpcEndpoint.wrap(buildAwsValue())
}
object VpcEndpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VpcEndpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcEndpoint =
      zio.aws.ec2.model.VpcEndpoint(
        vpcEndpointId.map(value => value),
        vpcEndpointType.map(value => value),
        vpcId.map(value => value),
        serviceName.map(value => value),
        state.map(value => value),
        policyDocument.map(value => value),
        routeTableIds.map(value => value),
        subnetIds.map(value => value),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipAddressType.map(value => value),
        dnsOptions.map(value => value.asEditable),
        privateDnsEnabled.map(value => value),
        requesterManaged.map(value => value),
        networkInterfaceIds.map(value => value),
        dnsEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTimestamp.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerId.map(value => value),
        lastError.map(value => value.asEditable)
      )
    def vpcEndpointId: Optional[String]
    def vpcEndpointType: Optional[zio.aws.ec2.model.VpcEndpointType]
    def vpcId: Optional[String]
    def serviceName: Optional[String]
    def state: Optional[zio.aws.ec2.model.State]
    def policyDocument: Optional[String]
    def routeTableIds: Optional[List[String]]
    def subnetIds: Optional[List[String]]
    def groups
        : Optional[List[zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly]]
    def ipAddressType: Optional[zio.aws.ec2.model.IpAddressType]
    def dnsOptions: Optional[zio.aws.ec2.model.DnsOptions.ReadOnly]
    def privateDnsEnabled: Optional[Boolean]
    def requesterManaged: Optional[Boolean]
    def networkInterfaceIds: Optional[List[String]]
    def dnsEntries: Optional[List[zio.aws.ec2.model.DnsEntry.ReadOnly]]
    def creationTimestamp: Optional[MillisecondDateTime]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def ownerId: Optional[String]
    def lastError: Optional[zio.aws.ec2.model.LastError.ReadOnly]
    def getVpcEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcEndpointType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcEndpointType] =
      AwsError.unwrapOptionField("vpcEndpointType", vpcEndpointType)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getRouteTableIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("routeTableIds", routeTableIds)
    def getSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getIpAddressType: ZIO[Any, AwsError, zio.aws.ec2.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getDnsOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.DnsOptions.ReadOnly] =
      AwsError.unwrapOptionField("dnsOptions", dnsOptions)
    def getPrivateDnsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privateDnsEnabled", privateDnsEnabled)
    def getRequesterManaged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("requesterManaged", requesterManaged)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getDnsEntries
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.DnsEntry.ReadOnly]] =
      AwsError.unwrapOptionField("dnsEntries", dnsEntries)
    def getCreationTimestamp: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getLastError: ZIO[Any, AwsError, zio.aws.ec2.model.LastError.ReadOnly] =
      AwsError.unwrapOptionField("lastError", lastError)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcEndpoint
  ) extends zio.aws.ec2.model.VpcEndpoint.ReadOnly {
    override val vpcEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => value: String)
    override val vpcEndpointType: Optional[zio.aws.ec2.model.VpcEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointType())
        .map(value => zio.aws.ec2.model.VpcEndpointType.wrap(value))
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.State.wrap(value))
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val routeTableIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val subnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val groups
        : Optional[List[zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.SecurityGroupIdentifier.wrap(item)
          }.toList
        )
    override val ipAddressType: Optional[zio.aws.ec2.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.ec2.model.IpAddressType.wrap(value))
    override val dnsOptions: Optional[zio.aws.ec2.model.DnsOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsOptions())
        .map(value => zio.aws.ec2.model.DnsOptions.wrap(value))
    override val privateDnsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsEnabled())
      .map(value => value: Boolean)
    override val requesterManaged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.requesterManaged())
      .map(value => value: Boolean)
    override val networkInterfaceIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dnsEntries
        : Optional[List[zio.aws.ec2.model.DnsEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DnsEntry.wrap(item)
          }.toList
        )
    override val creationTimestamp: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTimestamp())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val lastError: Optional[zio.aws.ec2.model.LastError.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastError())
        .map(value => zio.aws.ec2.model.LastError.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcEndpoint
  ): zio.aws.ec2.model.VpcEndpoint.ReadOnly = new Wrapper(impl)
}
