package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityGroupIdentifier(
    groupId: Optional[String] = Optional.Absent,
    groupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupIdentifier = {
    import SecurityGroupIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupIdentifier
      .builder()
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly =
    zio.aws.ec2.model.SecurityGroupIdentifier.wrap(buildAwsValue())
}
object SecurityGroupIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupIdentifier =
      zio.aws.ec2.model.SecurityGroupIdentifier(
        groupId.map(value => value),
        groupName.map(value => value)
      )
    def groupId: Optional[String]
    def groupName: Optional[String]
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupIdentifier
  ) extends zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly {
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupIdentifier
  ): zio.aws.ec2.model.SecurityGroupIdentifier.ReadOnly = new Wrapper(impl)
}
