package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestoreAddressToClassicRequest(publicIp: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest = {
    import RestoreAddressToClassicRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest
      .builder()
      .publicIp(publicIp: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RestoreAddressToClassicRequest.ReadOnly =
    zio.aws.ec2.model.RestoreAddressToClassicRequest.wrap(buildAwsValue())
}
object RestoreAddressToClassicRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreAddressToClassicRequest =
      zio.aws.ec2.model.RestoreAddressToClassicRequest(publicIp)
    def publicIp: String
    def getPublicIp: ZIO[Any, Nothing, String] = ZIO.succeed(publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest
  ) extends zio.aws.ec2.model.RestoreAddressToClassicRequest.ReadOnly {
    override val publicIp: String = impl.publicIp(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreAddressToClassicRequest
  ): zio.aws.ec2.model.RestoreAddressToClassicRequest.ReadOnly = new Wrapper(
    impl
  )
}
