package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import scala.jdk.CollectionConverters._
final case class RequestSpotInstancesRequest(
    availabilityZoneGroup: Optional[String] = Optional.Absent,
    blockDurationMinutes: Optional[Integer] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    launchGroup: Optional[String] = Optional.Absent,
    launchSpecification: Optional[
      zio.aws.ec2.model.RequestSpotLaunchSpecification
    ] = Optional.Absent,
    spotPrice: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.SpotInstanceType] = Optional.Absent,
    validFrom: Optional[DateTime] = Optional.Absent,
    validUntil: Optional[DateTime] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    instanceInterruptionBehavior: Optional[
      zio.aws.ec2.model.InstanceInterruptionBehavior
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest = {
    import RequestSpotInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest
      .builder()
      .optionallyWith(
        availabilityZoneGroup.map(value => value: java.lang.String)
      )(_.availabilityZoneGroup)
      .optionallyWith(
        blockDurationMinutes.map(value => value: java.lang.Integer)
      )(_.blockDurationMinutes)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(launchGroup.map(value => value: java.lang.String))(
        _.launchGroup
      )
      .optionallyWith(launchSpecification.map(value => value.buildAwsValue()))(
        _.launchSpecification
      )
      .optionallyWith(spotPrice.map(value => value: java.lang.String))(
        _.spotPrice
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestSpotInstancesRequest.ReadOnly =
    zio.aws.ec2.model.RequestSpotInstancesRequest.wrap(buildAwsValue())
}
object RequestSpotInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestSpotInstancesRequest =
      zio.aws.ec2.model.RequestSpotInstancesRequest(
        availabilityZoneGroup.map(value => value),
        blockDurationMinutes.map(value => value),
        clientToken.map(value => value),
        instanceCount.map(value => value),
        launchGroup.map(value => value),
        launchSpecification.map(value => value.asEditable),
        spotPrice.map(value => value),
        `type`.map(value => value),
        validFrom.map(value => value),
        validUntil.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceInterruptionBehavior.map(value => value)
      )
    def availabilityZoneGroup: Optional[String]
    def blockDurationMinutes: Optional[Integer]
    def clientToken: Optional[String]
    def instanceCount: Optional[Integer]
    def launchGroup: Optional[String]
    def launchSpecification
        : Optional[zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly]
    def spotPrice: Optional[String]
    def `type`: Optional[zio.aws.ec2.model.SpotInstanceType]
    def validFrom: Optional[DateTime]
    def validUntil: Optional[DateTime]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def instanceInterruptionBehavior
        : Optional[zio.aws.ec2.model.InstanceInterruptionBehavior]
    def getAvailabilityZoneGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneGroup", availabilityZoneGroup)
    def getBlockDurationMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("blockDurationMinutes", blockDurationMinutes)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getLaunchGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchGroup", launchGroup)
    def getLaunchSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchSpecification", launchSpecification)
    def getSpotPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotPrice", spotPrice)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.SpotInstanceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getInstanceInterruptionBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceInterruptionBehavior] =
      AwsError.unwrapOptionField(
        "instanceInterruptionBehavior",
        instanceInterruptionBehavior
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest
  ) extends zio.aws.ec2.model.RequestSpotInstancesRequest.ReadOnly {
    override val availabilityZoneGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneGroup())
      .map(value => value: String)
    override val blockDurationMinutes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDurationMinutes())
      .map(value => value: Integer)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val launchGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchGroup())
      .map(value => value: String)
    override val launchSpecification
        : Optional[zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchSpecification())
        .map(value =>
          zio.aws.ec2.model.RequestSpotLaunchSpecification.wrap(value)
        )
    override val spotPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotPrice())
      .map(value => value: String)
    override val `type`: Optional[zio.aws.ec2.model.SpotInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.SpotInstanceType.wrap(value))
    override val validFrom: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val instanceInterruptionBehavior
        : Optional[zio.aws.ec2.model.InstanceInterruptionBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInterruptionBehavior())
        .map(value =>
          zio.aws.ec2.model.InstanceInterruptionBehavior.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest
  ): zio.aws.ec2.model.RequestSpotInstancesRequest.ReadOnly = new Wrapper(impl)
}
