package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTransitGatewayMulticastGroupSourcesRequest(
    transitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId] =
      Optional.Absent,
    groupIpAddress: Optional[String] = Optional.Absent,
    networkInterfaceIds: Optional[Iterable[NetworkInterfaceId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest = {
    import RegisterTransitGatewayMulticastGroupSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value =>
          TransitGatewayMulticastDomainId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            NetworkInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly =
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
      .wrap(buildAwsValue())
}
object RegisterTransitGatewayMulticastGroupSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest =
      zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest(
        transitGatewayMulticastDomainId.map(value => value),
        groupIpAddress.map(value => value),
        networkInterfaceIds.map(value => value)
      )
    def transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId]
    def groupIpAddress: Optional[String]
    def networkInterfaceIds: Optional[List[NetworkInterfaceId]]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, AwsError, TransitGatewayMulticastDomainId] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[NetworkInterfaceId]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
  ) extends zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayMulticastDomainId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(value)
      )
    override val groupIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIpAddress())
      .map(value => value: String)
    override val networkInterfaceIds: Optional[List[NetworkInterfaceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.NetworkInterfaceId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
  ): zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest.ReadOnly =
    new Wrapper(impl)
}
