package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{OfferingId, DedicatedHostId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PurchaseHostReservationRequest(
    clientToken: Optional[String] = Optional.Absent,
    currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      Optional.Absent,
    hostIdSet: Iterable[DedicatedHostId],
    limitPrice: Optional[String] = Optional.Absent,
    offeringId: OfferingId,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest = {
    import PurchaseHostReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .hostIdSet(hostIdSet.map { item =>
        DedicatedHostId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(limitPrice.map(value => value: java.lang.String))(
        _.limitPrice
      )
      .offeringId(OfferingId.unwrap(offeringId): java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PurchaseHostReservationRequest.ReadOnly =
    zio.aws.ec2.model.PurchaseHostReservationRequest.wrap(buildAwsValue())
}
object PurchaseHostReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseHostReservationRequest =
      zio.aws.ec2.model.PurchaseHostReservationRequest(
        clientToken.map(value => value),
        currencyCode.map(value => value),
        hostIdSet,
        limitPrice.map(value => value),
        offeringId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[String]
    def currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues]
    def hostIdSet: List[DedicatedHostId]
    def limitPrice: Optional[String]
    def offeringId: OfferingId
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getHostIdSet: ZIO[Any, Nothing, List[DedicatedHostId]] =
      ZIO.succeed(hostIdSet)
    def getLimitPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("limitPrice", limitPrice)
    def getOfferingId: ZIO[Any, Nothing, OfferingId] = ZIO.succeed(offeringId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest
  ) extends zio.aws.ec2.model.PurchaseHostReservationRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val hostIdSet: List[DedicatedHostId] = impl
      .hostIdSet()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.DedicatedHostId(item)
      }
      .toList
    override val limitPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.limitPrice())
      .map(value => value: String)
    override val offeringId: OfferingId =
      zio.aws.ec2.model.primitives.OfferingId(impl.offeringId())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest
  ): zio.aws.ec2.model.PurchaseHostReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
