package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrefixList(
    cidrs: Optional[Iterable[String]] = Optional.Absent,
    prefixListId: Optional[String] = Optional.Absent,
    prefixListName: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.PrefixList = {
    import PrefixList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrefixList
      .builder()
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(prefixListId.map(value => value: java.lang.String))(
        _.prefixListId
      )
      .optionallyWith(prefixListName.map(value => value: java.lang.String))(
        _.prefixListName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrefixList.ReadOnly =
    zio.aws.ec2.model.PrefixList.wrap(buildAwsValue())
}
object PrefixList {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PrefixList] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrefixList = zio.aws.ec2.model.PrefixList(
      cidrs.map(value => value),
      prefixListId.map(value => value),
      prefixListName.map(value => value)
    )
    def cidrs: Optional[List[String]]
    def prefixListId: Optional[String]
    def prefixListName: Optional[String]
    def getCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getPrefixListId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListId", prefixListId)
    def getPrefixListName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListName", prefixListName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrefixList
  ) extends zio.aws.ec2.model.PrefixList.ReadOnly {
    override val cidrs: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val prefixListId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListId())
      .map(value => value: String)
    override val prefixListName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrefixList
  ): zio.aws.ec2.model.PrefixList.ReadOnly = new Wrapper(impl)
}
