package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{VerifiedAccessEndpointPortNumber, SubnetId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessEndpointLoadBalancerOptions(
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    protocol: Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      Optional.Absent,
    port: Optional[VerifiedAccessEndpointPortNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions = {
    import ModifyVerifiedAccessEndpointLoadBalancerOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        port.map(value =>
          VerifiedAccessEndpointPortNumber.unwrap(value): Integer
        )
      )(_.port)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessEndpointLoadBalancerOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions =
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions(
        subnetIds.map(value => value),
        protocol.map(value => value),
        port.map(value => value)
      )
    def subnetIds: Optional[List[SubnetId]]
    def protocol: Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol]
    def port: Optional[VerifiedAccessEndpointPortNumber]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPort: ZIO[Any, AwsError, VerifiedAccessEndpointPortNumber] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions.ReadOnly {
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val protocol
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessEndpointProtocol.wrap(value)
        )
    override val port: Optional[VerifiedAccessEndpointPortNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.port())
        .map(value =>
          zio.aws.ec2.model.primitives.VerifiedAccessEndpointPortNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions
  ): zio.aws.ec2.model.ModifyVerifiedAccessEndpointLoadBalancerOptions.ReadOnly =
    new Wrapper(impl)
}
