package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyIpamResponse(
    ipam: Optional[zio.aws.ec2.model.Ipam] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamResponse = {
    import ModifyIpamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamResponse
      .builder()
      .optionallyWith(ipam.map(value => value.buildAwsValue()))(_.ipam)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamResponse.ReadOnly =
    zio.aws.ec2.model.ModifyIpamResponse.wrap(buildAwsValue())
}
object ModifyIpamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamResponse =
      zio.aws.ec2.model.ModifyIpamResponse(ipam.map(value => value.asEditable))
    def ipam: Optional[zio.aws.ec2.model.Ipam.ReadOnly]
    def getIpam: ZIO[Any, AwsError, zio.aws.ec2.model.Ipam.ReadOnly] =
      AwsError.unwrapOptionField("ipam", ipam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamResponse
  ) extends zio.aws.ec2.model.ModifyIpamResponse.ReadOnly {
    override val ipam: Optional[zio.aws.ec2.model.Ipam.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipam())
        .map(value => zio.aws.ec2.model.Ipam.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamResponse
  ): zio.aws.ec2.model.ModifyIpamResponse.ReadOnly = new Wrapper(impl)
}
