package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyIpamResourceCidrRequest(
    resourceId: String,
    resourceCidr: String,
    resourceRegion: String,
    currentIpamScopeId: IpamScopeId,
    destinationIpamScopeId: Optional[IpamScopeId] = Optional.Absent,
    monitored: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest = {
    import ModifyIpamResourceCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest
      .builder()
      .resourceId(resourceId: java.lang.String)
      .resourceCidr(resourceCidr: java.lang.String)
      .resourceRegion(resourceRegion: java.lang.String)
      .currentIpamScopeId(
        IpamScopeId.unwrap(currentIpamScopeId): java.lang.String
      )
      .optionallyWith(
        destinationIpamScopeId.map(value =>
          IpamScopeId.unwrap(value): java.lang.String
        )
      )(_.destinationIpamScopeId)
      .monitored(monitored: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamResourceCidrRequest.ReadOnly =
    zio.aws.ec2.model.ModifyIpamResourceCidrRequest.wrap(buildAwsValue())
}
object ModifyIpamResourceCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamResourceCidrRequest =
      zio.aws.ec2.model.ModifyIpamResourceCidrRequest(
        resourceId,
        resourceCidr,
        resourceRegion,
        currentIpamScopeId,
        destinationIpamScopeId.map(value => value),
        monitored
      )
    def resourceId: String
    def resourceCidr: String
    def resourceRegion: String
    def currentIpamScopeId: IpamScopeId
    def destinationIpamScopeId: Optional[IpamScopeId]
    def monitored: Boolean
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getResourceCidr: ZIO[Any, Nothing, String] = ZIO.succeed(resourceCidr)
    def getResourceRegion: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceRegion)
    def getCurrentIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(currentIpamScopeId)
    def getDestinationIpamScopeId: ZIO[Any, AwsError, IpamScopeId] = AwsError
      .unwrapOptionField("destinationIpamScopeId", destinationIpamScopeId)
    def getMonitored: ZIO[Any, Nothing, Boolean] = ZIO.succeed(monitored)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest
  ) extends zio.aws.ec2.model.ModifyIpamResourceCidrRequest.ReadOnly {
    override val resourceId: String = impl.resourceId(): String
    override val resourceCidr: String = impl.resourceCidr(): String
    override val resourceRegion: String = impl.resourceRegion(): String
    override val currentIpamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.currentIpamScopeId())
    override val destinationIpamScopeId: Optional[IpamScopeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationIpamScopeId())
        .map(value => zio.aws.ec2.model.primitives.IpamScopeId(value))
    override val monitored: Boolean = impl.monitored(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamResourceCidrRequest
  ): zio.aws.ec2.model.ModifyIpamResourceCidrRequest.ReadOnly = new Wrapper(
    impl
  )
}
