package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateIamInstanceProfileSpecificationRequest(
    arn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest = {
    import LaunchTemplateIamInstanceProfileSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
      .wrap(buildAwsValue())
}
object LaunchTemplateIamInstanceProfileSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest =
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[String]
    def name: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
  ) extends zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
  ): zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
