package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceIpv6AddressRequest(
    ipv6Address: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest = {
    import InstanceIpv6AddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest
      .builder()
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceIpv6AddressRequest.ReadOnly =
    zio.aws.ec2.model.InstanceIpv6AddressRequest.wrap(buildAwsValue())
}
object InstanceIpv6AddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceIpv6AddressRequest =
      zio.aws.ec2.model
        .InstanceIpv6AddressRequest(ipv6Address.map(value => value))
    def ipv6Address: Optional[String]
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest
  ) extends zio.aws.ec2.model.InstanceIpv6AddressRequest.ReadOnly {
    override val ipv6Address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Address())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressRequest
  ): zio.aws.ec2.model.InstanceIpv6AddressRequest.ReadOnly = new Wrapper(impl)
}
