package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportVolumeTaskDetails(
    availabilityZone: Optional[String] = Optional.Absent,
    bytesConverted: Optional[Long] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    image: Optional[zio.aws.ec2.model.DiskImageDescription] = Optional.Absent,
    volume: Optional[zio.aws.ec2.model.DiskImageVolumeDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails = {
    import ImportVolumeTaskDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(bytesConverted.map(value => value: java.lang.Long))(
        _.bytesConverted
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(image.map(value => value.buildAwsValue()))(_.image)
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly =
    zio.aws.ec2.model.ImportVolumeTaskDetails.wrap(buildAwsValue())
}
object ImportVolumeTaskDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportVolumeTaskDetails =
      zio.aws.ec2.model.ImportVolumeTaskDetails(
        availabilityZone.map(value => value),
        bytesConverted.map(value => value),
        description.map(value => value),
        image.map(value => value.asEditable),
        volume.map(value => value.asEditable)
      )
    def availabilityZone: Optional[String]
    def bytesConverted: Optional[Long]
    def description: Optional[String]
    def image: Optional[zio.aws.ec2.model.DiskImageDescription.ReadOnly]
    def volume: Optional[zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getBytesConverted: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesConverted", bytesConverted)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImage
        : ZIO[Any, AwsError, zio.aws.ec2.model.DiskImageDescription.ReadOnly] =
      AwsError.unwrapOptionField("image", image)
    def getVolume: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly
    ] = AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails
  ) extends zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val bytesConverted: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesConverted())
      .map(value => value: Long)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val image
        : Optional[zio.aws.ec2.model.DiskImageDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.image())
        .map(value => zio.aws.ec2.model.DiskImageDescription.wrap(value))
    override val volume
        : Optional[zio.aws.ec2.model.DiskImageVolumeDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volume())
        .map(value => zio.aws.ec2.model.DiskImageVolumeDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails
  ): zio.aws.ec2.model.ImportVolumeTaskDetails.ReadOnly = new Wrapper(impl)
}
