package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportSnapshotTask(
    description: Optional[String] = Optional.Absent,
    importTaskId: Optional[String] = Optional.Absent,
    snapshotTaskDetail: Optional[zio.aws.ec2.model.SnapshotTaskDetail] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportSnapshotTask = {
    import ImportSnapshotTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportSnapshotTask
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(importTaskId.map(value => value: java.lang.String))(
        _.importTaskId
      )
      .optionallyWith(snapshotTaskDetail.map(value => value.buildAwsValue()))(
        _.snapshotTaskDetail
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportSnapshotTask.ReadOnly =
    zio.aws.ec2.model.ImportSnapshotTask.wrap(buildAwsValue())
}
object ImportSnapshotTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportSnapshotTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportSnapshotTask =
      zio.aws.ec2.model.ImportSnapshotTask(
        description.map(value => value),
        importTaskId.map(value => value),
        snapshotTaskDetail.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[String]
    def importTaskId: Optional[String]
    def snapshotTaskDetail
        : Optional[zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImportTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
    def getSnapshotTaskDetail
        : ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly] =
      AwsError.unwrapOptionField("snapshotTaskDetail", snapshotTaskDetail)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportSnapshotTask
  ) extends zio.aws.ec2.model.ImportSnapshotTask.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val importTaskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.importTaskId())
      .map(value => value: String)
    override val snapshotTaskDetail
        : Optional[zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotTaskDetail())
        .map(value => zio.aws.ec2.model.SnapshotTaskDetail.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportSnapshotTask
  ): zio.aws.ec2.model.ImportSnapshotTask.ReadOnly = new Wrapper(impl)
}
