package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ImageState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ImageState
}
object ImageState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ImageState
  ): zio.aws.ec2.model.ImageState = value match {
    case software.amazon.awssdk.services.ec2.model.ImageState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ImageState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.ImageState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.ImageState.INVALID =>
      val r = invalid
      r
    case software.amazon.awssdk.services.ec2.model.ImageState.DEREGISTERED =>
      val r = deregistered
      r
    case software.amazon.awssdk.services.ec2.model.ImageState.TRANSIENT =>
      val r = transient
      r
    case software.amazon.awssdk.services.ec2.model.ImageState.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.ImageState.ERROR =>
      val r = error
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ImageState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ImageState =
      software.amazon.awssdk.services.ec2.model.ImageState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.ImageState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ImageState =
      software.amazon.awssdk.services.ec2.model.ImageState.PENDING
  }
  case object available extends zio.aws.ec2.model.ImageState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ImageState =
      software.amazon.awssdk.services.ec2.model.ImageState.AVAILABLE
  }
  case object invalid extends zio.aws.ec2.model.ImageState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ImageState =
      software.amazon.awssdk.services.ec2.model.ImageState.INVALID
  }
  case object deregistered extends zio.aws.ec2.model.ImageState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ImageState =
      software.amazon.awssdk.services.ec2.model.ImageState.DEREGISTERED
  }
  case object transient extends zio.aws.ec2.model.ImageState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ImageState =
      software.amazon.awssdk.services.ec2.model.ImageState.TRANSIENT
  }
  case object failed extends zio.aws.ec2.model.ImageState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ImageState =
      software.amazon.awssdk.services.ec2.model.ImageState.FAILED
  }
  case object error extends zio.aws.ec2.model.ImageState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.ImageState =
      software.amazon.awssdk.services.ec2.model.ImageState.ERROR
  }
}
