package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpnConnectionDeviceTypeId, VpnConnectionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVpnConnectionDeviceSampleConfigurationRequest(
    vpnConnectionId: VpnConnectionId,
    vpnConnectionDeviceTypeId: VpnConnectionDeviceTypeId,
    internetKeyExchangeVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest = {
    import GetVpnConnectionDeviceSampleConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .vpnConnectionDeviceTypeId(
        VpnConnectionDeviceTypeId.unwrap(
          vpnConnectionDeviceTypeId
        ): java.lang.String
      )
      .optionallyWith(
        internetKeyExchangeVersion.map(value => value: java.lang.String)
      )(_.internetKeyExchangeVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest
      .wrap(buildAwsValue())
}
object GetVpnConnectionDeviceSampleConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest =
      zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest(
        vpnConnectionId,
        vpnConnectionDeviceTypeId,
        internetKeyExchangeVersion.map(value => value)
      )
    def vpnConnectionId: VpnConnectionId
    def vpnConnectionDeviceTypeId: VpnConnectionDeviceTypeId
    def internetKeyExchangeVersion: Optional[String]
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getVpnConnectionDeviceTypeId
        : ZIO[Any, Nothing, VpnConnectionDeviceTypeId] =
      ZIO.succeed(vpnConnectionDeviceTypeId)
    def getInternetKeyExchangeVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "internetKeyExchangeVersion",
        internetKeyExchangeVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest
  ) extends zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val vpnConnectionDeviceTypeId: VpnConnectionDeviceTypeId =
      zio.aws.ec2.model.primitives
        .VpnConnectionDeviceTypeId(impl.vpnConnectionDeviceTypeId())
    override val internetKeyExchangeVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.internetKeyExchangeVersion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest
  ): zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
