package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayAttachmentPropagationsResponse(
    transitGatewayAttachmentPropagations: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayAttachmentPropagation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse = {
    import GetTransitGatewayAttachmentPropagationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse
      .builder()
      .optionallyWith(
        transitGatewayAttachmentPropagations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayAttachmentPropagations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayAttachmentPropagationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse =
      zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse(
        transitGatewayAttachmentPropagations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayAttachmentPropagations: Optional[
      List[zio.aws.ec2.model.TransitGatewayAttachmentPropagation.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getTransitGatewayAttachmentPropagations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayAttachmentPropagation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayAttachmentPropagations",
      transitGatewayAttachmentPropagations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse
  ) extends zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.ReadOnly {
    override val transitGatewayAttachmentPropagations: Optional[
      List[zio.aws.ec2.model.TransitGatewayAttachmentPropagation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentPropagations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayAttachmentPropagation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayAttachmentPropagationsResponse
  ): zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.ReadOnly =
    new Wrapper(impl)
}
