package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  GetSubnetCidrReservationsMaxResults,
  SubnetId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetSubnetCidrReservationsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    subnetId: SubnetId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[GetSubnetCidrReservationsMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest = {
    import GetSubnetCidrReservationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          GetSubnetCidrReservationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetSubnetCidrReservationsRequest.ReadOnly =
    zio.aws.ec2.model.GetSubnetCidrReservationsRequest.wrap(buildAwsValue())
}
object GetSubnetCidrReservationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetSubnetCidrReservationsRequest =
      zio.aws.ec2.model.GetSubnetCidrReservationsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def subnetId: SubnetId
    def nextToken: Optional[String]
    def maxResults: Optional[GetSubnetCidrReservationsMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, GetSubnetCidrReservationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest
  ) extends zio.aws.ec2.model.GetSubnetCidrReservationsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[GetSubnetCidrReservationsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .GetSubnetCidrReservationsMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetSubnetCidrReservationsRequest
  ): zio.aws.ec2.model.GetSubnetCidrReservationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
