package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetEventType {
  def unwrap: software.amazon.awssdk.services.ec2.model.FleetEventType
}
object FleetEventType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetEventType
  ): zio.aws.ec2.model.FleetEventType = value match {
    case software.amazon.awssdk.services.ec2.model.FleetEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetEventType.INSTANCE_CHANGE =>
      val r = `instance-change`
      r
    case software.amazon.awssdk.services.ec2.model.FleetEventType.FLEET_CHANGE =>
      val r = `fleet-change`
      r
    case software.amazon.awssdk.services.ec2.model.FleetEventType.SERVICE_ERROR =>
      val r = `service-error`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.FleetEventType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetEventType =
      software.amazon.awssdk.services.ec2.model.FleetEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object `instance-change` extends zio.aws.ec2.model.FleetEventType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetEventType =
      software.amazon.awssdk.services.ec2.model.FleetEventType.INSTANCE_CHANGE
  }
  case object `fleet-change` extends zio.aws.ec2.model.FleetEventType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetEventType =
      software.amazon.awssdk.services.ec2.model.FleetEventType.FLEET_CHANGE
  }
  case object `service-error` extends zio.aws.ec2.model.FleetEventType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetEventType =
      software.amazon.awssdk.services.ec2.model.FleetEventType.SERVICE_ERROR
  }
}
