package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ElasticGpuId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ElasticGpuAssociation(
    elasticGpuId: Optional[ElasticGpuId] = Optional.Absent,
    elasticGpuAssociationId: Optional[String] = Optional.Absent,
    elasticGpuAssociationState: Optional[String] = Optional.Absent,
    elasticGpuAssociationTime: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation = {
    import ElasticGpuAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation
      .builder()
      .optionallyWith(
        elasticGpuId.map(value => ElasticGpuId.unwrap(value): java.lang.String)
      )(_.elasticGpuId)
      .optionallyWith(
        elasticGpuAssociationId.map(value => value: java.lang.String)
      )(_.elasticGpuAssociationId)
      .optionallyWith(
        elasticGpuAssociationState.map(value => value: java.lang.String)
      )(_.elasticGpuAssociationState)
      .optionallyWith(
        elasticGpuAssociationTime.map(value => value: java.lang.String)
      )(_.elasticGpuAssociationTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly =
    zio.aws.ec2.model.ElasticGpuAssociation.wrap(buildAwsValue())
}
object ElasticGpuAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ElasticGpuAssociation =
      zio.aws.ec2.model.ElasticGpuAssociation(
        elasticGpuId.map(value => value),
        elasticGpuAssociationId.map(value => value),
        elasticGpuAssociationState.map(value => value),
        elasticGpuAssociationTime.map(value => value)
      )
    def elasticGpuId: Optional[ElasticGpuId]
    def elasticGpuAssociationId: Optional[String]
    def elasticGpuAssociationState: Optional[String]
    def elasticGpuAssociationTime: Optional[String]
    def getElasticGpuId: ZIO[Any, AwsError, ElasticGpuId] =
      AwsError.unwrapOptionField("elasticGpuId", elasticGpuId)
    def getElasticGpuAssociationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("elasticGpuAssociationId", elasticGpuAssociationId)
    def getElasticGpuAssociationState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "elasticGpuAssociationState",
        elasticGpuAssociationState
      )
    def getElasticGpuAssociationTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("elasticGpuAssociationTime", elasticGpuAssociationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation
  ) extends zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly {
    override val elasticGpuId: Optional[ElasticGpuId] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticGpuId())
      .map(value => zio.aws.ec2.model.primitives.ElasticGpuId(value))
    override val elasticGpuAssociationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticGpuAssociationId())
        .map(value => value: String)
    override val elasticGpuAssociationState: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticGpuAssociationState())
        .map(value => value: String)
    override val elasticGpuAssociationTime: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticGpuAssociationTime())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ElasticGpuAssociation
  ): zio.aws.ec2.model.ElasticGpuAssociation.ReadOnly = new Wrapper(impl)
}
