package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MaximumIops,
  BaselineBandwidthInMbps,
  BaselineThroughputInMBps,
  BaselineIops,
  MaximumBandwidthInMbps,
  MaximumThroughputInMBps
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EbsOptimizedInfo(
    baselineBandwidthInMbps: Optional[BaselineBandwidthInMbps] =
      Optional.Absent,
    baselineThroughputInMBps: Optional[BaselineThroughputInMBps] =
      Optional.Absent,
    baselineIops: Optional[BaselineIops] = Optional.Absent,
    maximumBandwidthInMbps: Optional[MaximumBandwidthInMbps] = Optional.Absent,
    maximumThroughputInMBps: Optional[MaximumThroughputInMBps] =
      Optional.Absent,
    maximumIops: Optional[MaximumIops] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EbsOptimizedInfo = {
    import EbsOptimizedInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EbsOptimizedInfo
      .builder()
      .optionallyWith(
        baselineBandwidthInMbps.map(value =>
          BaselineBandwidthInMbps.unwrap(value): Integer
        )
      )(_.baselineBandwidthInMbps)
      .optionallyWith(
        baselineThroughputInMBps.map(value =>
          BaselineThroughputInMBps.unwrap(value): java.lang.Double
        )
      )(_.baselineThroughputInMBps)
      .optionallyWith(
        baselineIops.map(value => BaselineIops.unwrap(value): Integer)
      )(_.baselineIops)
      .optionallyWith(
        maximumBandwidthInMbps.map(value =>
          MaximumBandwidthInMbps.unwrap(value): Integer
        )
      )(_.maximumBandwidthInMbps)
      .optionallyWith(
        maximumThroughputInMBps.map(value =>
          MaximumThroughputInMBps.unwrap(value): java.lang.Double
        )
      )(_.maximumThroughputInMBps)
      .optionallyWith(
        maximumIops.map(value => MaximumIops.unwrap(value): Integer)
      )(_.maximumIops)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EbsOptimizedInfo.ReadOnly =
    zio.aws.ec2.model.EbsOptimizedInfo.wrap(buildAwsValue())
}
object EbsOptimizedInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EbsOptimizedInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EbsOptimizedInfo =
      zio.aws.ec2.model.EbsOptimizedInfo(
        baselineBandwidthInMbps.map(value => value),
        baselineThroughputInMBps.map(value => value),
        baselineIops.map(value => value),
        maximumBandwidthInMbps.map(value => value),
        maximumThroughputInMBps.map(value => value),
        maximumIops.map(value => value)
      )
    def baselineBandwidthInMbps: Optional[BaselineBandwidthInMbps]
    def baselineThroughputInMBps: Optional[BaselineThroughputInMBps]
    def baselineIops: Optional[BaselineIops]
    def maximumBandwidthInMbps: Optional[MaximumBandwidthInMbps]
    def maximumThroughputInMBps: Optional[MaximumThroughputInMBps]
    def maximumIops: Optional[MaximumIops]
    def getBaselineBandwidthInMbps
        : ZIO[Any, AwsError, BaselineBandwidthInMbps] = AwsError
      .unwrapOptionField("baselineBandwidthInMbps", baselineBandwidthInMbps)
    def getBaselineThroughputInMBps
        : ZIO[Any, AwsError, BaselineThroughputInMBps] = AwsError
      .unwrapOptionField("baselineThroughputInMBps", baselineThroughputInMBps)
    def getBaselineIops: ZIO[Any, AwsError, BaselineIops] =
      AwsError.unwrapOptionField("baselineIops", baselineIops)
    def getMaximumBandwidthInMbps: ZIO[Any, AwsError, MaximumBandwidthInMbps] =
      AwsError.unwrapOptionField(
        "maximumBandwidthInMbps",
        maximumBandwidthInMbps
      )
    def getMaximumThroughputInMBps
        : ZIO[Any, AwsError, MaximumThroughputInMBps] = AwsError
      .unwrapOptionField("maximumThroughputInMBps", maximumThroughputInMBps)
    def getMaximumIops: ZIO[Any, AwsError, MaximumIops] =
      AwsError.unwrapOptionField("maximumIops", maximumIops)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EbsOptimizedInfo
  ) extends zio.aws.ec2.model.EbsOptimizedInfo.ReadOnly {
    override val baselineBandwidthInMbps: Optional[BaselineBandwidthInMbps] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineBandwidthInMbps())
        .map(value =>
          zio.aws.ec2.model.primitives.BaselineBandwidthInMbps(value)
        )
    override val baselineThroughputInMBps: Optional[BaselineThroughputInMBps] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineThroughputInMBps())
        .map(value =>
          zio.aws.ec2.model.primitives.BaselineThroughputInMBps(value)
        )
    override val baselineIops: Optional[BaselineIops] = zio.aws.core.internal
      .optionalFromNullable(impl.baselineIops())
      .map(value => zio.aws.ec2.model.primitives.BaselineIops(value))
    override val maximumBandwidthInMbps: Optional[MaximumBandwidthInMbps] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumBandwidthInMbps())
        .map(value =>
          zio.aws.ec2.model.primitives.MaximumBandwidthInMbps(value)
        )
    override val maximumThroughputInMBps: Optional[MaximumThroughputInMBps] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumThroughputInMBps())
        .map(value =>
          zio.aws.ec2.model.primitives.MaximumThroughputInMBps(value)
        )
    override val maximumIops: Optional[MaximumIops] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumIops())
      .map(value => zio.aws.ec2.model.primitives.MaximumIops(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EbsOptimizedInfo
  ): zio.aws.ec2.model.EbsOptimizedInfo.ReadOnly = new Wrapper(impl)
}
