package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DnsServersOptionsModifyStructure(
    customDnsServers: Optional[Iterable[String]] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DnsServersOptionsModifyStructure = {
    import DnsServersOptionsModifyStructure.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DnsServersOptionsModifyStructure
      .builder()
      .optionallyWith(
        customDnsServers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.customDnsServers)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly =
    zio.aws.ec2.model.DnsServersOptionsModifyStructure.wrap(buildAwsValue())
}
object DnsServersOptionsModifyStructure {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DnsServersOptionsModifyStructure
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DnsServersOptionsModifyStructure =
      zio.aws.ec2.model.DnsServersOptionsModifyStructure(
        customDnsServers.map(value => value),
        enabled.map(value => value)
      )
    def customDnsServers: Optional[List[String]]
    def enabled: Optional[Boolean]
    def getCustomDnsServers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("customDnsServers", customDnsServers)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DnsServersOptionsModifyStructure
  ) extends zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly {
    override val customDnsServers: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDnsServers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DnsServersOptionsModifyStructure
  ): zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly = new Wrapper(
    impl
  )
}
