package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DirectoryServiceAuthentication(
    directoryId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthentication = {
    import DirectoryServiceAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthentication
      .builder()
      .optionallyWith(directoryId.map(value => value: java.lang.String))(
        _.directoryId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DirectoryServiceAuthentication.ReadOnly =
    zio.aws.ec2.model.DirectoryServiceAuthentication.wrap(buildAwsValue())
}
object DirectoryServiceAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DirectoryServiceAuthentication =
      zio.aws.ec2.model
        .DirectoryServiceAuthentication(directoryId.map(value => value))
    def directoryId: Optional[String]
    def getDirectoryId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("directoryId", directoryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthentication
  ) extends zio.aws.ec2.model.DirectoryServiceAuthentication.ReadOnly {
    override val directoryId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthentication
  ): zio.aws.ec2.model.DirectoryServiceAuthentication.ReadOnly = new Wrapper(
    impl
  )
}
