package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DhcpOptions(
    dhcpConfigurations: Optional[
      Iterable[zio.aws.ec2.model.DhcpConfiguration]
    ] = Optional.Absent,
    dhcpOptionsId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.DhcpOptions = {
    import DhcpOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DhcpOptions
      .builder()
      .optionallyWith(
        dhcpConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dhcpConfigurations)
      .optionallyWith(dhcpOptionsId.map(value => value: java.lang.String))(
        _.dhcpOptionsId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DhcpOptions.ReadOnly =
    zio.aws.ec2.model.DhcpOptions.wrap(buildAwsValue())
}
object DhcpOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.DhcpOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DhcpOptions =
      zio.aws.ec2.model.DhcpOptions(
        dhcpConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dhcpOptionsId.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dhcpConfigurations
        : Optional[List[zio.aws.ec2.model.DhcpConfiguration.ReadOnly]]
    def dhcpOptionsId: Optional[String]
    def ownerId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getDhcpConfigurations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DhcpConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("dhcpConfigurations", dhcpConfigurations)
    def getDhcpOptionsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dhcpOptionsId", dhcpOptionsId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DhcpOptions
  ) extends zio.aws.ec2.model.DhcpOptions.ReadOnly {
    override val dhcpConfigurations
        : Optional[List[zio.aws.ec2.model.DhcpConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dhcpConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DhcpConfiguration.wrap(item)
          }.toList
        )
    override val dhcpOptionsId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dhcpOptionsId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DhcpOptions
  ): zio.aws.ec2.model.DhcpOptions.ReadOnly = new Wrapper(impl)
}
