package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcClassicLinkRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    vpcIds: Optional[Iterable[VpcId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest = {
    import DescribeVpcClassicLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        vpcIds.map(value =>
          value.map { item =>
            VpcId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcClassicLinkRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcClassicLinkRequest.wrap(buildAwsValue())
}
object DescribeVpcClassicLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcClassicLinkRequest =
      zio.aws.ec2.model.DescribeVpcClassicLinkRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcIds.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def vpcIds: Optional[List[VpcId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getVpcIds: ZIO[Any, AwsError, List[VpcId]] =
      AwsError.unwrapOptionField("vpcIds", vpcIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest
  ) extends zio.aws.ec2.model.DescribeVpcClassicLinkRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val vpcIds: Optional[List[VpcId]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpcId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkRequest
  ): zio.aws.ec2.model.DescribeVpcClassicLinkRequest.ReadOnly = new Wrapper(
    impl
  )
}
