package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  VpcId,
  DescribeVpcClassicLinkDnsSupportNextToken,
  DescribeVpcClassicLinkDnsSupportMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeVpcClassicLinkDnsSupportRequest(
    maxResults: Optional[DescribeVpcClassicLinkDnsSupportMaxResults] =
      Optional.Absent,
    nextToken: Optional[DescribeVpcClassicLinkDnsSupportNextToken] =
      Optional.Absent,
    vpcIds: Optional[Iterable[VpcId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest = {
    import DescribeVpcClassicLinkDnsSupportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          DescribeVpcClassicLinkDnsSupportMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          DescribeVpcClassicLinkDnsSupportNextToken.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        vpcIds.map(value =>
          value.map { item =>
            VpcId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpcIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
      .wrap(buildAwsValue())
}
object DescribeVpcClassicLinkDnsSupportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest =
      zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        vpcIds.map(value => value)
      )
    def maxResults: Optional[DescribeVpcClassicLinkDnsSupportMaxResults]
    def nextToken: Optional[DescribeVpcClassicLinkDnsSupportNextToken]
    def vpcIds: Optional[List[VpcId]]
    def getMaxResults
        : ZIO[Any, AwsError, DescribeVpcClassicLinkDnsSupportMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken
        : ZIO[Any, AwsError, DescribeVpcClassicLinkDnsSupportNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcIds: ZIO[Any, AwsError, List[VpcId]] =
      AwsError.unwrapOptionField("vpcIds", vpcIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
  ) extends zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest.ReadOnly {
    override val maxResults
        : Optional[DescribeVpcClassicLinkDnsSupportMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeVpcClassicLinkDnsSupportMaxResults(value)
        )
    override val nextToken
        : Optional[DescribeVpcClassicLinkDnsSupportNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeVpcClassicLinkDnsSupportNextToken(value)
        )
    override val vpcIds: Optional[List[VpcId]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpcId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
  ): zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest.ReadOnly =
    new Wrapper(impl)
}
