package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{CarrierGatewayMaxResults, CarrierGatewayId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeCarrierGatewaysRequest(
    carrierGatewayIds: Optional[Iterable[CarrierGatewayId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[CarrierGatewayMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest = {
    import DescribeCarrierGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest
      .builder()
      .optionallyWith(
        carrierGatewayIds.map(value =>
          value.map { item =>
            CarrierGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.carrierGatewayIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => CarrierGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeCarrierGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCarrierGatewaysRequest.wrap(buildAwsValue())
}
object DescribeCarrierGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCarrierGatewaysRequest =
      zio.aws.ec2.model.DescribeCarrierGatewaysRequest(
        carrierGatewayIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def carrierGatewayIds: Optional[List[CarrierGatewayId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[CarrierGatewayMaxResults]
    def nextToken: Optional[String]
    def getCarrierGatewayIds: ZIO[Any, AwsError, List[CarrierGatewayId]] =
      AwsError.unwrapOptionField("carrierGatewayIds", carrierGatewayIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, CarrierGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeCarrierGatewaysRequest.ReadOnly {
    override val carrierGatewayIds: Optional[List[CarrierGatewayId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.carrierGatewayIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.CarrierGatewayId(item)
          }.toList
        )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[CarrierGatewayMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.CarrierGatewayMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCarrierGatewaysRequest
  ): zio.aws.ec2.model.DescribeCarrierGatewaysRequest.ReadOnly = new Wrapper(
    impl
  )
}
