package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessInstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVerifiedAccessInstanceRequest(
    verifiedAccessInstanceId: VerifiedAccessInstanceId,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest = {
    import DeleteVerifiedAccessInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest
      .builder()
      .verifiedAccessInstanceId(
        VerifiedAccessInstanceId.unwrap(
          verifiedAccessInstanceId
        ): java.lang.String
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVerifiedAccessInstanceRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVerifiedAccessInstanceRequest.wrap(buildAwsValue())
}
object DeleteVerifiedAccessInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVerifiedAccessInstanceRequest =
      zio.aws.ec2.model.DeleteVerifiedAccessInstanceRequest(
        verifiedAccessInstanceId,
        clientToken.map(value => value)
      )
    def verifiedAccessInstanceId: VerifiedAccessInstanceId
    def clientToken: Optional[String]
    def getVerifiedAccessInstanceId
        : ZIO[Any, Nothing, VerifiedAccessInstanceId] =
      ZIO.succeed(verifiedAccessInstanceId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest
  ) extends zio.aws.ec2.model.DeleteVerifiedAccessInstanceRequest.ReadOnly {
    override val verifiedAccessInstanceId: VerifiedAccessInstanceId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessInstanceId(impl.verifiedAccessInstanceId())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceRequest
  ): zio.aws.ec2.model.DeleteVerifiedAccessInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
