package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse(
    localGatewayRouteTableVirtualInterfaceGroupAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse = {
    import DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
      .builder()
      .optionallyWith(
        localGatewayRouteTableVirtualInterfaceGroupAssociation.map(value =>
          value.buildAwsValue()
        )
      )(_.localGatewayRouteTableVirtualInterfaceGroupAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.ReadOnly =
    zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
      .wrap(buildAwsValue())
}
object DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse =
      zio.aws.ec2.model
        .DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse(
          localGatewayRouteTableVirtualInterfaceGroupAssociation.map(value =>
            value.asEditable
          )
        )
    def localGatewayRouteTableVirtualInterfaceGroupAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
    ]
    def getLocalGatewayRouteTableVirtualInterfaceGroupAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "localGatewayRouteTableVirtualInterfaceGroupAssociation",
      localGatewayRouteTableVirtualInterfaceGroupAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
  ) extends zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.ReadOnly {
    override val localGatewayRouteTableVirtualInterfaceGroupAssociation: Optional[
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.localGatewayRouteTableVirtualInterfaceGroupAssociation()
      )
      .map(value =>
        zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse
  ): zio.aws.ec2.model.DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
