package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataResponse(
    id: Optional[String] = Optional.Absent,
    source: Optional[String] = Optional.Absent,
    destination: Optional[String] = Optional.Absent,
    metric: Optional[zio.aws.ec2.model.MetricType] = Optional.Absent,
    statistic: Optional[zio.aws.ec2.model.StatisticType] = Optional.Absent,
    period: Optional[zio.aws.ec2.model.PeriodType] = Optional.Absent,
    metricPoints: Optional[Iterable[zio.aws.ec2.model.MetricPoint]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DataResponse = {
    import DataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DataResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(destination.map(value => value: java.lang.String))(
        _.destination
      )
      .optionallyWith(metric.map(value => value.unwrap))(_.metric)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .optionallyWith(
        metricPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricPoints)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DataResponse.ReadOnly =
    zio.aws.ec2.model.DataResponse.wrap(buildAwsValue())
}
object DataResponse {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.DataResponse] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DataResponse =
      zio.aws.ec2.model.DataResponse(
        id.map(value => value),
        source.map(value => value),
        destination.map(value => value),
        metric.map(value => value),
        statistic.map(value => value),
        period.map(value => value),
        metricPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[String]
    def source: Optional[String]
    def destination: Optional[String]
    def metric: Optional[zio.aws.ec2.model.MetricType]
    def statistic: Optional[zio.aws.ec2.model.StatisticType]
    def period: Optional[zio.aws.ec2.model.PeriodType]
    def metricPoints: Optional[List[zio.aws.ec2.model.MetricPoint.ReadOnly]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destination", destination)
    def getMetric: ZIO[Any, AwsError, zio.aws.ec2.model.MetricType] =
      AwsError.unwrapOptionField("metric", metric)
    def getStatistic: ZIO[Any, AwsError, zio.aws.ec2.model.StatisticType] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getPeriod: ZIO[Any, AwsError, zio.aws.ec2.model.PeriodType] =
      AwsError.unwrapOptionField("period", period)
    def getMetricPoints
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.MetricPoint.ReadOnly]] =
      AwsError.unwrapOptionField("metricPoints", metricPoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DataResponse
  ) extends zio.aws.ec2.model.DataResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val destination: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => value: String)
    override val metric: Optional[zio.aws.ec2.model.MetricType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metric())
        .map(value => zio.aws.ec2.model.MetricType.wrap(value))
    override val statistic: Optional[zio.aws.ec2.model.StatisticType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.ec2.model.StatisticType.wrap(value))
    override val period: Optional[zio.aws.ec2.model.PeriodType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.period())
        .map(value => zio.aws.ec2.model.PeriodType.wrap(value))
    override val metricPoints
        : Optional[List[zio.aws.ec2.model.MetricPoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.MetricPoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DataResponse
  ): zio.aws.ec2.model.DataResponse.ReadOnly = new Wrapper(impl)
}
